<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invest in Ogun State</title>
    <link rel="shortcut icon" href="images/ologo.png" type="image/x-icon">
    <meta name="description" content="Invest in Ogun State, Nigeria - Explore diverse investment opportunities in agriculture, manufacturing, logistics, and more.">
    <meta name="keywords" content="Ogun State, investment, agriculture, manufacturing, logistics, tourism, technology, real estate, government support">
    <meta name="author" content="Ogun State Government">
    <meta property="og:title" content="Invest in Ogun State">
    <meta property="og:description" content="Discover the investment potential of Ogun State,">
    <meta property="og:image" content="images/ologo.png">
    <meta property="og:url" content="https://invest.ogunstate.gov.ng">
    <meta property="og:type" content="website">
    <link rel="stylesheet" href="./fontawesome-free-6.4.2-web/css/all.css">
    <link rel="stylesheet" href="styles/style.css">
</head>
<body>


    <header class="header-container">
        <div class="head-div">
            <div class="search-container">
                <input type="text" id="search" placeholder="Search">
                <label for="search"><i class="fa fa-search" aria-hidden="true"></i></label>
                
            </div>
        </div>
        <div class="top-bar">
            <div class="logo"><img src="./images/ologo.png" alt="Ogun state Logo" width="70"></div>
            <div class="main-nav-wrapper">
                <div class="main-nav-background"></div>
                <!-- Desktop Navigation -->
                <nav class="main-nav">
                    <a href="#" class="active">Home</a>
                    <div class="dropdown"> 
                        <a href="#" class="nav-item-dark dropdown-toggle"> About Us <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Our Services</a>
                            <a href="#">Key Partner</a>
                            <a href="#">Success Stories</a>
                            <a href="#">About Ogun state</a>
                            <a href="#">Why invest in Ogun state</a>
                        </div>
                    </div>
                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Investment Opportunities <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Agriculture</a>
                            <a href="#">Manufacturing</a>
                            <a href="#">infrastructure</a>
                            <a href="#">Solid Minerals</a>
                            <a href="#">Transportation and Logistics</a>
                            <a href="#">Energy</a>
                            <a href="#">ICT</a>
                            <a href="#">Tourism</a>
                        </div>
                    </div>
                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Investor Resources <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Steps to land Acquisition</a>
                            <a href="#">Contruction Permits</a>
                            <a href="#">Investor relation Guide</a>
                            <a href="#">Investment Opportunity Compedium</a>
                            <a href="#">Intaractive Map</a>
                            <a href="#">FAQ</a>
                            <a href="#">E-Form and Template</a>
                            <a href="#">KYC Form</a>
                            <a href="#">Land Acquisition Application</a>
                            <a href="#">Permit Application</a>
                            <a href="#">Patnership Proposal</a>
                            <a href="#">Application Portals</a>
                            <a href="#">Available Investment Zone</a>
                            <a href="#">Location of Major Projects</a>
                        </div>
                    </div>
                    
                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Ministries and Porcesses <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Collaboration With ministries</a>
                            <a href="#">Lands and Urban</a>
                            <a href="#">Commerce and Industry</a>
                            <a href="#">Process Illusion</a>
                        </div>
                    </div>

                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Media <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Latest News</a>
                            <a href="#">Upcoming Events</a>
                            <a href="#">Press releases</a>
                            <a href="#">Media Gallery</a>
                            <a href="#">Photos</a>
                            <a href="#">Videos</a>
                            <a href="#">Infography</a>
                        </div>
                    </div>


                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Contact Us <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Inquiry Form</a>
                            <a href="#">Contact Details</a>
                            <a href="#">Social Media Links</a>
                            <a href="#">Live Chat</a>
                        </div>
                    </div>
                </nav>
            </div>
            <div class="logo logo-right"><img src="./images/investonlybg.png" alt="" width="70"></div>
        </div>
    </header>


    <!-- Small device Header -->
    <div class="small-header">
        <div class="logo"><img src="./images/ologo.png" alt="Ogun state Logo" width="70"></div>
        <!-- Mobile Menu Button -->
        <button class="mobile-menu-button" aria-label="Open Menu">
            <i class="fa fa-bars"></i>
        </button>
        <div class="logo logo-right"><img src="./images/investonlybg.png" alt="" width="70"></div>
        <!-- Mobile Navigation Menu -->
        <nav class="mobile-nav" aria-label="Mobile Navigation">
            <a href="#">Home</a>
            <div class="dropdown"> 
                <a href="#" class="nav-item-dark dropdown-toggle"> About Us <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Our Services</a>
                    <a href="#">Key Partner</a>
                    <a href="#">Success Stories</a>
                    <a href="#">About Ogun state</a>
                    <a href="#">Why invest in Ogun state</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Investment Opportunities <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Agriculture</a>
                    <a href="#">Manufacturing</a>
                    <a href="#">infrastructure</a>
                    <a href="#">Solid Minerals</a>
                    <a href="#">Transportation and Logistics</a>
                    <a href="#">Energy</a>
                    <a href="#">ICT</a>
                    <a href="#">Tourism</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Investor Resources <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Steps to land Acquisition</a>
                    <a href="#">Contruction Permits</a>
                    <a href="#">Investor relation Guide</a>
                    <a href="#">Investment Opportunity Compedium</a>
                    <a href="#">Intaractive Map</a>
                    <a href="#">FAQ</a>
                    <a href="#">E-Form and Template</a>
                    <a href="#">KYC Form</a>
                    <a href="#">Land Acquisition Application</a>
                    <a href="#">Permit Application</a>
                    <a href="#">Patnership Proposal</a>
                    <a href="#">Application Portals</a>
                    <a href="#">Available Investment Zone</a>
                    <a href="#">Location of Major Projects</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Ministries and Porcesses <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Collaboration With ministries</a>
                    <a href="#">Lands and Urban</a>
                    <a href="#">Commerce and Industry</a>
                    <a href="#">Process Illusion</a>
                </div>
            </div>

            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Media <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Latest News</a>
                    <a href="#">Upcoming Events</a>
                    <a href="#">Press releases</a>
                    <a href="#">Media Gallery</a>
                    <a href="#">Photos</a>
                    <a href="#">Videos</a>
                    <a href="#">Infography</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Contact Us <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Inquiry Form</a>
                    <a href="#">Contact Details</a>
                    <a href="#">Social Media Links</a>
                    <a href="#">Live Chat</a>
                </div>
            </div>
        </nav>
    </div>
    <!-- End small Device header -->


    <main>
        <!-- Hero Section Carousel -->
        <section id="hero-carousel">
           <div class="carousel-slides-container" style="position: relative; width: 100%; height: 100%;">
                <div class="carousel-slide" style="opacity: 1; z-index: 10;">
                    <img src="./images/banner1.jpg" alt="Airport Runway">
                    <div class="carousel-overlay"></div>
                </div>
                <div class="carousel-slide" style="opacity: 0; z-index: 0;">
                    <img src="./images/bannerogun4.jpg" alt="Industrial Hub">
                    <div class="carousel-overlay"></div>
                </div>
                 <div class="carousel-slide" style="opacity: 0; z-index: 0;">
                    <img src="./images/ogunbanner12.jpg" alt="Lush Farmland">
                    <div class="carousel-overlay"></div>
                </div>
            </div>

            <div class="hero-content container">
                <div class="content-inner">
                    <div class="content-head">
                        <div class="invest-in">
                            <div class="line"></div>
                            <span>Invest in </span>
                            <div class="line"></div>
                        </div>
                        <h1> OGUN STATE</h1>
                        <p class="hero-subtitle">THE #1 INVESTMENT DESTINATION IN NIGERIA</p>
                    </div>

                   <div class="hero-contents-card">
                        <div class="conts">
                            <i class="fas fa-money-bill-wave-alt"></i>
                            <div class="text">
                                 <h3>Access to 400m West African consumers via borders</h3>
                                 <p>Borders Lagos, Oyo, Osun, Ondo & Benin; a major logistics hub</p>
                            </div>
                        </div>
                        <div class="conts">
                            <i class="fa fa-bank"></i>
                           <div class="text">
                                <h3 >74% of land arable; only 30% currently cultivated</h3>
                                <p>Key crops: Cassava, Cocoa, Maize, Rice, Cotton, Oil Palm, others</p>
                           </div>
                        </div>
                        <div class="conts">
                            <i class="fa fa-globe"></i>
                            <div class="text">
                                <h3>30% of Nigeria’s national solid minerals output</h3>
                                <p>Limestone, Bitumen, Granite, Phosphate, Clay, Sand, Kaolin</p>
                            </div>
                            
                        </div>
                        <div class="conts">
                            <i class="fa fa-globe"></i>
                            <div class="text">
                                <h3>Next to Lagos, 5th largest economy in Africa</h3>
                                <p>Drives trade, logistics, and industrial growth across West Africa</p>
                            </div>
                            
                        </div>
                    </div>

                    <div class="hero-buttons">
                        <a href="#" class="btn-primary">
                           <span>Why Invest In Ogun state</span>
                           <i class="fa fa-arrow-circle-right"></i>
                        </a>
                        <a href="#" class="btn-primary warning">
                           <span>Get Started Now</span>
                           <i class="fa fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="carousel-controls">
                <button type="button" id="prev-btn">
                    <i class="fa fa-arrow-circle-left fa-2x"></i>
                </button>
                <button type="button" id="next-btn">
                    <i class="fa fa-arrow-circle-right fa-2x"></i>
                </button>
            </div> 
        </section>

        <!-- Vision Section -->
        <section class="vision-section">
            <div class="container">
                <div class="vision-grid">
                    <div class="overlay"></div>
                    <div class="video-player-popup">
                        <div style="padding:56.25% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/1090024069?h=99dca8db7b&amp;badge=0&amp;autopause=0&amp;autoplay=1&amp;player_id=0&amp;app_id=58479&amp;dnt=1" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Invest In Ogun State"></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
                        <div class="video-caption">
                            <p>HIS EXCELLENCY</p>
                            <h3>PRINCE DAPO ABIODUN, <span>CON</span></h3>
                        </div>
                    </div>

                    <div class="video-player-mockup">
                        <img src="./images/govogun3.jpg" alt="Image of the Governor">
                        <span class="fa fa-play play-button"></span>
                    </div>
                    <div class="vision-text">
                        <h2 style="text-transform:uppercase; font-size: 25px;">Ogun State is Nigeria’s <br>premier investment frontier</h2>
                        <p>
                         Ogun State is strategically positioned, richly endowed, and boldly future-focused. Located next to Lagos, Africa’s fifth-largest economy, the Gateway state offers unrivaled access to domestic and international markets, powered by cutting-edge infrastructure such as the Gateway Agro-Cargo Airport, Kajola Dry Port City, and the proposed Olokola Deep Sea Port
                            <br><br>
                            OgunInvest is the engine behind Ogun State’s dynamic investment climate - 
                            bridging opportunity with execution for both local and global investors. 
                            The agency is strategically positioned to actualize the state’s ambition 
                            of becoming Nigeria’s industrial capital and a top investment destination 
                            in West Africa. </p>
                        <p class="governor-name">HIS EXCELLENCY, <BR>PRINCE DAPO ABIODUN, <span><em>CON</em></span></p>
                        <p class="governor-title">CHAIRMAN, OGUNNINVEST.</p>
                        <a href="#" class="learn-more-link">
                            <span>Learn more</span>
                             <svg xmlns="http://www.w3.org/2000/svg" style="height: 1.5rem; width: 1.5rem;" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Investment Opportunities Section -->
        <section class="investment">
            <div class="container">
                <h1 class="invest">Investible Sectors</h1>
                 <div class="carousel-container">
                    <div class="carousel-window">
                        <div class="carousel-track">

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/agricogun.jpg" alt="Mountain">
                                        <h3>Agriculture</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Agriculture</h4>
                                        <p>Ogun State offers exciting investment opportunities in agriculture, driven by vast expanse of arable land, strategic access to market, and strong government-backed initiatives. </p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/manufogun.jpg" alt="Mountain">
                                        <h3>Manufacturing</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Manufacturing</h4>
                                        <p>Ogun State is Nigeria’s industrial engine room—home to over 5,000 manufacturing firms and the largest concentration of industrial estates in the country.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/solidminogun.jpg" alt="Mountain">
                                        <h3>Solid Minerals</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Solid Minerals</h4>
                                        <p>Ogun State stands at the forefront of Nigeria’s solid mineral production, offering vast, untapped reserves of limestone, granite, laterite, and more.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/transogun.jpg" alt="Mountain">
                                        <h3>Transportation & Logistics</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Transportation & Logistics</h4>
                                        <p>Ogun State is a rising logistics hub with road, rail, air, and sea access—boosting trade, transport, and industry through key assets like the Agro-Cargo Airport and Kajola Dry Port.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/energyogun.jpg" alt="Mountain">
                                        <h3>Energy Sector</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Energy Sector</h4>
                                        <p>Ogun State leads in energy innovation with opportunities in IPPs, renewables, and industrial power—offering solar-ready land and a stable environment for reliable energy investment.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/cultureogun.jpg" alt="Mountain">
                                        <h3>Culture & Tourism</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Culture & Tourism</h4>
                                        <p style="padding-right:40px;">From Nollywood sets to vibrant crafts and festivals, Ogun State blends culture, history, and entertainment—positioning tourism as a thriving investment in storytelling and creativity.</p>
                                    </div>
                                </div>
                            </div>

                            
                        </div>
                    </div>

                    <button class="carousel-btn prev-btn" id="prevBtn">‹</button>
                    <button class="carousel-btn next-btn" id="nextBtn">›</button>

                    <div class="carousel-indicators">
                    </div>
                </div>

            </div>
        </section>


        <!-- Our Services section -->
        <section id="service">
            <div class="container">
                <h1 class="serve">OUR SERVICES
                    
                </h1>
                

                <div class="services-container">

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-users"></i>
                         <h3>Your One-Stop Investment Partner</h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                       At OgunInvest, we offer end-to-end support - from your first inquiry to full project execution. Our One-Stop-Shop model ensures that investors receive seamless, coordinated assistance across every stage of the investment lifecycle
                       </div>
                    </div>

                   

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-newspaper"></i>
                         <h3>Investment Promotion & Facilitation</h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                        At OgunInvest, we promote high-potential sectors and support investors with opportunity mapping, regulatory guidance, and strategic insights—ensuring direct access to key stakeholders for smart decisions.
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-users"></i>
                         <h3>Investment Support & Aftercare</h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                        Our commitment goes beyond project launch. OgunInvest offers ongoing support—resolving challenges, enabling expansion, and linking investors with government agencies, partners, and key resources to ensure long-term business success.
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-money-bill-1"></i>
                         <h3>Project Management Assistance</h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                       OgunInvest provides hands-on support across the full project lifecycle—from site selection and stakeholder coordination to milestone tracking and issue resolution—ensuring your investment stays on track, on time, and aligned with your goals.
                       </div>
                    </div>

                </div>

                <!-- Add this below the services-container -->
                <div class="service-info-mobile"></div>

            </div>
        </section>
    </main>


    <!-- Footer Section -->
    <footer class="ogun-footer">
        <div class="footer-contact-us">
            <h1>Ready To Connect ? </h1>
            <button>Contact Us <i class="fa fa-arrow-circle-right"></i></button>
        </div>
        <div class="footer-top">
            <div class="footer-col contact">
                <div class="footer-logo">
                    <img src="./images/ogivlogonly.png" alt="Ogun State Logo" style="height:48px;">
                    <span>OGUNINVEST</span>
                </div>
                <div class="footer-contact">
                    <p><i class="fas fa-phone-alt"></i> +234 909 166 1337</p>
                    <p><i class="fas fa-envelope"></i> invest@ogunstate.gov.ng</p>
                </div>
                <div class="footer-social">
                    <a href="#" aria-label="X"><i class="fab fa-x-twitter"></i></a>
                    <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
                    <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" aria-label="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
            <div class="footer-col about">
                <h4>QUICK LINKS</h4>
                <ul>
                    <li><a href="#">Why Invest In Ogun</a></li>
                    <li><a href="#">Investable Sectors</a></li>
                    <li><a href="#">Investors' Resources</a></li>
                </ul>
            </div>
            <div class="footer-col subscribe">
                <h4>SUBSCRIBE TO OGUN'S GROWTH STORY</h4>
                <form class="subscribe-form">
                    <input type="email" placeholder="Email Address" required>
                    <button type="submit">SUBSCRIBE <i class="fas fa-arrow-right"></i></button>
                </form>
                <button class="feedback-btn">FEEDBACK <i class="fas fa-arrow-right"></i></button>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="footer-links">
                <a href="#">PRIVACY POLICY</a>
                <a href="#">TERMS OF USE</a>
                <a href="#">FRAUD ALERT</a>
                <a href="#">CSR POLICY</a>
            </div>
        </div>
        <div class="footer-bottom2">
            <div class="footer-copy">
                &copy; Ogun State. All Rights Reserved.
            </div>
            <div class="footer-update">
                Last Updated on 26/06/2025
            </div>
        </div>
    </footer>
    
    <script src="./scripts/script.js"></script>
    <script src="./scripts/cards.js"></script>
</body>
</html>
