<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invest in Ogun State</title>
    <link rel="shortcut icon" href="images/ologo.png" type="image/x-icon">
    <meta name="description" content="Invest in Ogun State, Nigeria - Explore diverse investment opportunities in agriculture, manufacturing, logistics, and more.">
    <meta name="keywords" content="Ogun State, investment, agriculture, manufacturing, logistics, tourism, technology, real estate, government support">
    <meta name="author" content="Ogun State Government">
    <meta property="og:title" content="Invest in Ogun State">
    <meta property="og:description" content="Discover the investment potential of Ogun State,">
    <meta property="og:image" content="images/ologo.png">
    <meta property="og:url" content="https://invest.ogunstate.gov.ng">
    <meta property="og:type" content="website">
    <link rel="stylesheet" href="./fontawesome-free-6.4.2-web/css/all.css">
    <link rel="stylesheet" href="styles/style.css">
</head>
<body>


    <header class="header-container">
        <div class="head-div">
            <div class="search-container">
                <input type="text" id="search" placeholder="Search">
                <label for="search"><i class="fa fa-search" aria-hidden="true"></i></label>
                
            </div>
        </div>
        <div class="top-bar">
            <div class="logo"><img src="./images/ologo.png" alt="Ogun state Logo" width="70"></div>
            <div class="main-nav-wrapper">
                <div class="main-nav-background"></div>
                <!-- Desktop Navigation -->
                <nav class="main-nav">
                    <a href="#" class="active">Home</a>
                    <div class="dropdown"> 
                        <a href="#" class="nav-item-dark dropdown-toggle"> About Us <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Who We Are</a>
                            <a href="#">Our Services</a>
                            <a href="#">Key Partner</a>
                            <a href="#">Success Stories</a>
                            <a href="#">About Ogun state</a>
                            <a href="#">Why invest in Ogun state</a>
                        </div>
                    </div>
                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Investment Sectors <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Agriculture</a>
                            <a href="#">Manufacturing</a>
                            <a href="#">infrastructure</a>
                            <a href="#">Solid Minerals</a>
                            <a href="#">Transportation and Logistics</a>
                            <a href="#">Energy</a>
                            <a href="#">ICT</a>
                            <a href="#">Tourism</a>
                        </div>
                    </div>

                    <a href="#">Investor Resources</a>

                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle"> <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Steps to land Acquisition</a>
                            <a href="#">Contruction Permits</a>
                            <a href="#">Investor relation Guide</a>
                            <a href="#">Investment Opportunity Compedium</a>
                            <a href="#">Intaractive Map</a>
                            <a href="#">FAQ</a>
                            <a href="#">E-Form and Template</a>
                            <a href="#">KYC Form</a>
                            <a href="#">Land Acquisition Application</a>
                            <a href="#">Permit Application</a>
                            <a href="#">Patnership Proposal</a>
                            <a href="#">Application Portals</a>
                            <a href="#">Available Investment Zone</a>
                            <a href="#">Location of Major Projects</a>
                        </div>
                    </div>
                    
                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Ministries and Porcesses <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Collaboration With ministries</a>
                            <a href="#">Lands and Urban</a>
                            <a href="#">Commerce and Industry</a>
                            <a href="#">Process Illusion</a>
                        </div>
                    </div>

                    <div class="dropdown">
                        <a href="#" class="nav-item-dark dropdown-toggle">Media <i class="fa fa-caret-down"></i></a>
                        <div class="dropdown-menu">
                            <a href="#">Latest News</a>
                            <a href="#">Upcoming Events</a>
                            <a href="#">Press releases</a>
                            <a href="#">Media Gallery</a>
                            <a href="#">Photos</a>
                            <a href="#">Videos</a>
                            <a href="#">Infography</a>
                        </div>
                    </div>


                     <a href="#">Contact Us</a>
                </nav>
            </div>
            <div class="logo logo-right"><img src="./images/investonlybg.png" alt="" width="70"></div>
        </div>
    </header>


    <!-- Small device Header -->
    <div class="small-header">
        <div class="logo"><img src="./images/ologo.png" alt="Ogun state Logo" width="70"></div>
        <!-- Mobile Menu Button -->
        <button class="mobile-menu-button" aria-label="Open Menu">
            <i class="fa fa-bars"></i>
        </button>
        <div class="logo logo-right"><img src="./images/investonlybg.png" alt="" width="70"></div>
        <!-- Mobile Navigation Menu -->
        <nav class="mobile-nav" aria-label="Mobile Navigation">
            <a href="#">Home</a>
            <div class="dropdown"> 
                <a href="#" class="nav-item-dark dropdown-toggle"> About Us <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Our Services</a>
                    <a href="#">Key Partner</a>
                    <a href="#">Success Stories</a>
                    <a href="#">About Ogun state</a>
                    <a href="#">Why invest in Ogun state</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Investment Opportunities <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Agriculture</a>
                    <a href="#">Manufacturing</a>
                    <a href="#">infrastructure</a>
                    <a href="#">Solid Minerals</a>
                    <a href="#">Transportation and Logistics</a>
                    <a href="#">Energy</a>
                    <a href="#">ICT</a>
                    <a href="#">Tourism</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Investor Resources <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Steps to land Acquisition</a>
                    <a href="#">Contruction Permits</a>
                    <a href="#">Investor relation Guide</a>
                    <a href="#">Investment Opportunity Compedium</a>
                    <a href="#">Intaractive Map</a>
                    <a href="#">FAQ</a>
                    <a href="#">E-Form and Template</a>
                    <a href="#">KYC Form</a>
                    <a href="#">Land Acquisition Application</a>
                    <a href="#">Permit Application</a>
                    <a href="#">Patnership Proposal</a>
                    <a href="#">Application Portals</a>
                    <a href="#">Available Investment Zone</a>
                    <a href="#">Location of Major Projects</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Ministries and Porcesses <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Collaboration With ministries</a>
                    <a href="#">Lands and Urban</a>
                    <a href="#">Commerce and Industry</a>
                    <a href="#">Process Illusion</a>
                </div>
            </div>

            <div class="dropdown">
                <a href="#" class="nav-item-dark dropdown-toggle">Media <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-menu">
                    <a href="#">Latest News</a>
                    <a href="#">Upcoming Events</a>
                    <a href="#">Press releases</a>
                    <a href="#">Media Gallery</a>
                    <a href="#">Photos</a>
                    <a href="#">Videos</a>
                    <a href="#">Infography</a>
                </div>
            </div>
            <a href="#">Contact Us</a>
           
        </nav>
    </div>
    <!-- End small Device header -->


    <main>
        <!-- Hero Section Carousel -->
        <section id="hero-carousel">
            <div class="carousel-slides-container" style="position: relative; width: 100%; height: 100%;">
                <div class="carousel-slide" style="opacity: 1; z-index: 10;">
                    <img src="./images/banner1.jpg" alt="Airport Runway">
                    <div class="carousel-overlay"></div>
                </div>
                <div class="carousel-slide" style="opacity: 0; z-index: 0;">
                    <img src="./images/bannerogun4.jpg" alt="Industrial Hub">
                    <div class="carousel-overlay"></div>
                </div>
                 <div class="carousel-slide" style="opacity: 0; z-index: 0;">
                    <img src="./images/ogunbanner12.jpg" alt="Lush Farmland">
                    <div class="carousel-overlay"></div>
                </div>
            </div>

            <div class="hero-content container">
                <div class="content-inner">
                    <div class="content-head">
                        <div class="invest-in">
                            <div class="line"></div>
                            <span>Invest in </span>
                            <div class="line"></div>
                        </div>
                        <h1> OGUN STATE</h1>
                        <p class="hero-subtitle">THE #1 INVESTMENT DESTINATION IN NIGERIA</p>
                    </div>

                    <div class="hero-contents-card">
                        <div class="conts">
                            <i class="fas fa-money-bill-wave-alt"></i>
                            <div class="text">
                                 <h3>Access to 400m West African consumers via borders</h3>
                                 <p>Borders Lagos, Oyo, Osun, Ondo & Benin; a major logistics hub</p>
                            </div>
                        </div>
                        <div class="conts">
                            <i class="fa fa-bank"></i>
                           <div class="text">
                                <h3 >74% of land arable; only 30% currently cultivated</h3>
                                <p>Key crops: Cassava, Cocoa, Maize, Rice, Cotton, Oil Palm, others</p>
                           </div>
                        </div>
                        <div class="conts">
                            <i class="fa fa-globe"></i>
                            <div class="text">
                                <h3>30% of Nigeria’s national solid minerals output</h3>
                                <p>Limestone, Bitumen, Granite, Phosphate, Clay, Sand, Kaolin</p>
                            </div>
                            
                        </div>
                        <div class="conts">
                            <i class="fa fa-globe"></i>
                            <div class="text">
                                <h3>Next to Lagos, 5th largest economy in Africa</h3>
                                <p>Drives trade, logistics, and industrial growth across West Africa</p>
                            </div>
                            
                        </div>
                    </div>

                    <div class="hero-buttons">
                        <a href="#" class="btn-primary">
                           <span>Why Invest In Ogun state</span>
                           <i class="fa fa-arrow-circle-right"></i>
                        </a>
                        <a href="#" class="btn-primary warning">
                           <span>Get Started Now</span>
                           <i class="fa fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="carousel-controls">
                <button type="button" id="prev-btn">
                    <i class="fa fa-arrow-circle-left fa-2x"></i>
                </button>
                <button type="button" id="next-btn">
                    <i class="fa fa-arrow-circle-right fa-2x"></i>
                </button>
            </div> 
        </section>

       <!-- Vision Section -->
        <section class="vision-section">
            <div class="container">
                <div class="vision-grid">
                    <div class="overlay"></div>
                    <div class="video-player-popup">
                        <div style="padding:56.25% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/1090024069?h=99dca8db7b&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479&amp;dnt=1" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Invest In Ogun State"></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
                        <div class="video-caption">
                            <p>HIS EXCELLENCY</p>
                            <h3>PRINCE DAPO ABIODUN, <span>CON</span></h3>
                        </div>
                    </div>

                    <div class="video-player-mockup">
                        <img src="./images/govogun.jpg" alt="Image of the Governor">
                        <span class="fa fa-play play-button"></span>
                    </div>
                    <div class="vision-text">
                        <h2 style="text-transform:uppercase; font-size: 25px;">Our vision is to provide focused and qualitative governance.</h2>
                        <p>And to create an enabling environment for public-private partnership, which is fundamental towards achieving sustainable economic development and individual prosperity for the people of Ogun State.</p>
                        <p class="governor-name">PRINCE DAPO ABIODUN, <span>CON</span></p>
                        <p class="governor-title">GOVERNOR, OGUN STATE</p>
                        <a href="#" class="learn-more-link">
                            <span>Learn more</span>
                             <svg xmlns="http://www.w3.org/2000/svg" style="height: 1.5rem; width: 1.5rem;" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </section>


        <!-- Investment Opportunities Section -->
        <section class="investment">
            <div class="container">
                <h1 class="invest">Investible Sectors</h1>
                 <div class="carousel-container">
                    <div class="carousel-window">
                        <div class="carousel-track">

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/bannereogun3.jpeg" alt="Mountain">
                                        <h3>Capital Goods</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Capital Goods</h4>
                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Debitis corrupti nesciunt vitae nisi porro expedita voluptatem voluptates corporis, esse impedit!</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/bannerogun1.jpeg" alt="Mountain">
                                        <h3>Electric Mobility</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Electric Mobility</h4>
                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Debitis corrupti nesciunt vitae nisi porro expedita voluptatem voluptates corporis, esse impedit!</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/bannerogun2.jpeg" alt="Mountain">
                                        <h3>Electric Components and Materials</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Electric Components and Materials</h4>
                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Debitis corrupti nesciunt vitae nisi porro expedita voluptatem voluptates corporis, esse impedit!</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/contactfirst.jpg" alt="Mountain">
                                        <h3>Food Processing</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Food Processing</h4>
                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Debitis corrupti nesciunt vitae nisi porro expedita voluptatem voluptates corporis, esse impedit!</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/investonlybg.png" alt="Mountain">
                                        <h3>Pharmacitical</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Pharmacitical</h4>
                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Debitis corrupti nesciunt vitae nisi porro expedita voluptatem voluptates corporis, esse impedit!</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/bannerogun2.jpeg" alt="Mountain">
                                        <h3>Electric Components and Materials</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Electric Components and Materials</h4>
                                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Debitis corrupti nesciunt vitae nisi porro expedita voluptatem voluptates corporis, esse impedit!</p>
                                    </div>
                                </div>
                            </div>

                            
                        </div>
                    </div>

                    <button class="carousel-btn prev-btn" id="prevBtn">‹</button>
                    <button class="carousel-btn next-btn" id="nextBtn">›</button>

                    <div class="carousel-indicators">
                    </div>
                </div>

            </div>
        </section>


        <!-- Our Services section -->
        <section id="service">
            <div class="container">
                <h1 class="serve">OUR SERVICES</h1>

                <div class="services-container">

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-users"></i>
                         <h3>Investor Targeting</h3>
                       </div>
                       <div class="service-card-bottom">
                        <ul>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum. </li>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum.</li>
                        </ul>
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-money-bill-1"></i>
                         <h3>Investment Promotion</h3>
                       </div>
                       <div class="service-card-bottom">
                        <ul>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum. </li>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum.</li>
                        </ul>
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-newspaper"></i>
                         <h3>Policy Clarity</h3>
                       </div>
                       <div class="service-card-bottom">
                        <ul>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum. </li>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum.</li>
                        </ul>
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-users"></i>
                         <h3>Investor Targeting</h3>
                       </div>
                       <div class="service-card-bottom">
                        <ul>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum. </li>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum.</li>
                        </ul>
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-money-bill-1"></i>
                         <h3>Investment Promotion</h3>
                       </div>
                       <div class="service-card-bottom">
                        <ul>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum. </li>
                            <li>Lorem ipsum, dolor sit amet consectetur adipisicing elit. Iste, facere voluptas a blanditiis iusto nostrum. facere voluptas a blanditiis iusto nostrum.facere voluptas a blanditiis iusto nostrum.</li>
                        </ul>
                       </div>
                    </div>

                </div>

                <!-- Add this below the services-container -->
                <div class="service-info-mobile"></div>

            </div>
        </section>
    </main>


    <!-- Footer Section -->
    <footer class="ogun-footer">
        <div class="footer-contact-us">
            <h1>Ready To Connect ? </h1>
            <button>Contact Us <i class="fa fa-arrow-circle-right"></i></button>
        </div>
        <div class="footer-top">
            <div class="footer-col contact">
                <div class="footer-logo">
                    <img src="./images/investonlybg.png" alt="Ogun State Logo" style="height:48px;">
                    <span>INVEST OGUN</span>
                </div>
                <div class="footer-contact">
                    <p><i class="fas fa-phone-alt"></i> +234-803-000-0000</p>
                    <p><i class="fas fa-envelope"></i> invest@ogunstate.gov.ng</p>
                </div>
                <div class="footer-social">
                    <a href="#" aria-label="X"><i class="fab fa-x-twitter"></i></a>
                    <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
                    <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" aria-label="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
            <div class="footer-col about">
                <h4>ABOUT US</h4>
                <ul>
                    <li><a href="#">Ogun Opportunity</a></li>
                    <li><a href="#">Invest in Sectors</a></li>
                    <li><a href="#">Local Government Areas</a></li>
                </ul>
            </div>
            <div class="footer-col subscribe">
                <h4>SUBSCRIBE TO OGUN'S GROWTH STORY</h4>
                <form class="subscribe-form">
                    <input type="email" placeholder="Email Address" required>
                    <button type="submit">SUBSCRIBE <i class="fas fa-arrow-right"></i></button>
                </form>
                <button class="feedback-btn">FEEDBACK <i class="fas fa-arrow-right"></i></button>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="footer-links">
                <a href="#">PRIVACY POLICY</a>
                <a href="#">TERMS OF USE</a>
                <a href="#">FRAUD ALERT</a>
                <a href="#">CSR POLICY</a>
            </div>
        </div>
        <div class="footer-bottom2">
            <div class="footer-copy">
                &copy; Ogun State. All Rights Reserved.
            </div>
            <div class="footer-update">
                Last Updated on 26/06/2025
            </div>
        </div>
    </footer>
    
    <script src="./scripts/script.js"></script>
    <script src="./scripts/cards.js"></script>
</body>
</html>
