document.addEventListener('DOMContentLoaded', () => {
    const track = document.querySelector('.carousel-track');
    const cards = Array.from(track.children);
    const nextButton = document.querySelector('#nextBtn');
    const prevButton = document.querySelector('#prevBtn');
    const indicatorsContainer = document.querySelector('.carousel-indicators');

    if (!track || cards.length === 0) return;

    let currentSlide = 0;
    let autoPlayInterval;

    // Helper to determine cards per slide based on screen size
    const getCardsPerSlide = () => window.innerWidth <= 768 ? 1 : 3;

    // Calculate number of slides
    const getSlideCount = () => Math.ceil(cards.length / getCardsPerSlide());

    // Move to a specific slide
    const goToSlide = (slideIdx) => {
        const cardsPerSlide = getCardsPerSlide();
        const cardStyle = window.getComputedStyle(cards[0]);
        const cardMarginRight = parseFloat(cardStyle.marginRight);
        const cardWidth = cards[0].offsetWidth + cardMarginRight;
        const offset = -slideIdx * cardsPerSlide * cardWidth;
        track.style.transform = `translateX(${offset}px)`;
        currentSlide = slideIdx;
        updateButtonStates();
        updateIndicators();
    };

    // Setup indicators for each slide
    const setupIndicators = () => {
        indicatorsContainer.innerHTML = '';
        const slideCount = getSlideCount();
        for (let i = 0; i < slideCount; i++) {
            const dot = document.createElement('button');
            dot.classList.add('indicator-dot');
            dot.addEventListener('click', () => {
                goToSlide(i);
                resetAutoPlay();
            });
            indicatorsContainer.appendChild(dot);
        }
    };

    // Update which indicator is active
    const updateIndicators = () => {
        const dots = Array.from(indicatorsContainer.children);
        dots.forEach((dot, idx) => {
            dot.classList.toggle('active', idx === currentSlide);
        });
    };

    // Enable/disable prev/next buttons
    const updateButtonStates = () => {
        const slideCount = getSlideCount();
        prevButton.disabled = currentSlide === 0;
        nextButton.disabled = currentSlide === slideCount - 1;
    };

    // Next/Prev button handlers
    nextButton.addEventListener('click', () => {
        const slideCount = getSlideCount();
        if (currentSlide < slideCount - 1) {
            goToSlide(currentSlide + 1);
            resetAutoPlay();
        }
    });
    prevButton.addEventListener('click', () => {
        if (currentSlide > 0) {
            goToSlide(currentSlide - 1);
            resetAutoPlay();
        }
    });

    // Autoplay logic
    const startAutoPlay = () => {
        autoPlayInterval = setInterval(() => {
            const slideCount = getSlideCount();
            if (currentSlide < slideCount - 1) {
                goToSlide(currentSlide + 1);
            } else {
                goToSlide(0);
            }
        }, 7000);
    };
    const resetAutoPlay = () => {
        clearInterval(autoPlayInterval);
        startAutoPlay();
    };

    // Responsive: update on resize
    window.addEventListener('resize', () => {
        setupIndicators();
        goToSlide(0);
    });

    // Initial setup
    setupIndicators();
    goToSlide(0);
    startAutoPlay();
});










// Services card
function handleServiceCardClickMobileInit() {
  const serviceCards = document.querySelectorAll('.service-card');
  const infoMobile = document.querySelector('.service-info-mobile');


  serviceCards.forEach(card => {
    card.replaceWith(card.cloneNode(true));
  });

  const freshServiceCards = document.querySelectorAll('.service-card');

  function isMobile() {
    return window.innerWidth <= 900;
  }

  function showCardInfo(idx) {
    freshServiceCards.forEach((c, i) => c.classList.toggle('active', i === idx));
    const card = freshServiceCards[idx];
    if (!card) return;
    const top = card.querySelector('.service-card-top').cloneNode(true);
    const bottom = card.querySelector('.service-card-bottom').cloneNode(true);
    const h3 = bottom.querySelector('h3');
    if (h3) h3.style.display = 'block';
    infoMobile.innerHTML = '';
    infoMobile.appendChild(top);
    infoMobile.appendChild(bottom);
  }

  if (isMobile()) {
    showCardInfo(0);

    freshServiceCards.forEach((card, idx) => {
      card.onclick = function () {
        showCardInfo(idx);
        //infoMobile.scrollIntoView({ behavior: 'smooth', block: 'start' });
      };
    });
  } else {

    infoMobile.innerHTML = '';
    freshServiceCards.forEach(card => card.classList.remove('active'));

    freshServiceCards.forEach(card => { card.onclick = null; });
  }
}


window.addEventListener('DOMContentLoaded', handleServiceCardClickMobileInit);
window.addEventListener('resize', handleServiceCardClickMobileInit);