<?php 
    require_once "connect.php";

    // -------------------------------------------------------------------------------------
    if(isset($_POST['signin'])){
        $username = htmlspecialchars($_POST['username']);
        $password = htmlspecialchars($_POST['password']);

        $user = "SELECT * FROM admin WHERE username = ?";
        $stmt = $conn->prepare($user);
        $stmt->bind_param('s', $username);
        $stmt->execute();

        $result = $stmt->get_result();

        if($result->num_rows > 0){
            $admin_user = $result->fetch_assoc();
            if(password_verify($password, $admin_user['password'])){
                echo "<script> window.location.href = 'dashboard.php' </script>";
                $_SESSION['username'] = $admin_user['username'];    
            }else{
                echo "<alert class='alert alert-danger my-2 d-block'>Incorrect Password</alert>";
            }
        }else{
            echo "<alert class='alert alert-danger my-2 d-block'>Incorrect Credentials</alert>";
        }
    }

    // ------------------------------------------------------------------------------------
    // blog post 
    if(isset($_POST['publish'])){

        $blog_title = htmlspecialchars($_POST['title']);
        $blogcontent = htmlspecialchars($_POST['blogcontent']);
        $posted_by = "Oguninvest";

        if(isset($_FILES['blogimage'])){
            $image = $_FILES['blogimage']['name'];
            $tmp_name = $_FILES['blogimage']['tmp_name'];
            $path = "../assets/blogImages/".time()."_".$image;

            if(move_uploaded_file($tmp_name, $path)){

                $sql = "INSERT INTO blog (blog_image, posted_by, blog_title, blog_content) VALUES (?,?,?,?) ";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssss", $path, $posted_by,$blog_title, $blogcontent);
                if($stmt->execute()){
                    echo "
                        <script>
                            window.location.href = 'dashboard.php';
                        </script>
                    ";
                }else{
                    echo "<div class='alert alert-danger'>Could Not Insert into db</div>";
                }

            }else{
                echo "An error Occured, Cound Not Upload image";
            }
        }

    }


    // ------------------------------------------------------------------------------------
    // press post 
    if(isset($_POST['publishpress'])){

        $blog_title = htmlspecialchars($_POST['title']);
        $blogcontent = htmlspecialchars($_POST['pressContent']);
        $posted_by = "Oguninvest";

        if(isset($_FILES['pressimage'])){
            $image = $_FILES['pressimage']['name'];
            $tmp_name = $_FILES['pressimage']['tmp_name'];
            $path = "../assets/pressimages/".time()."_".$image;

            if(move_uploaded_file($tmp_name, $path)){

                $sql = "INSERT INTO press (press_image, press_title, press_content, posted_by) VALUES (?,?,?,?) ";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssss", $path, $blog_title,$blogcontent, $posted_by);
                if($stmt->execute()){
                    echo "
                        <script>
                            window.location.href = 'dashboard.php';
                        </script>
                    ";
                }else{
                    echo "<div class='alert alert-danger'>Could Not Insert into db</div>";
                }

            }else{
                echo "An error Occured, Cound Not Upload image";
            }
        }

    }

    
    // -------------------------------------------------------------------------------------
    // update blog post 
    if(isset($_POST['updateBlog'])){
        $blog_title = htmlspecialchars($_POST['blogtitle']);
        $blogid = htmlspecialchars($_POST['blogid']); 
        $blogContent = $_POST['blogContent'];
        
        $select_blog = "SELECT * FROM blog WHERE id = ?";
        $query = $conn->prepare($select_blog);
        $query->bind_param('i', $blogid);
        $query->execute();
        $result = $query->get_result();
        $blog = $result->fetch_assoc();

        $old_image = $blog['blog_image'];

        if (isset($_FILES['blog_image']) && $_FILES['blog_image']['error'] === UPLOAD_ERR_OK && !empty($_FILES['blog_image']['name'])) {
            $originalName = $_FILES['blog_image']['name'];
            $tmp_name = $_FILES['blog_image']['tmp_name'];

            $ext = pathinfo($originalName, PATHINFO_EXTENSION);

            $newFileName = time() . '_' . uniqid() . '.' . $ext;

            $folder = "../assets/blogImages/" . $newFileName;

            if ($old_image && file_exists($old_image)) {
                unlink($old_image);
            }

            if (move_uploaded_file($tmp_name, $folder)) {
                // bla bla bla sheep have u any wool ......  yes sir yes sir three bags full ....sing or life 
            } else {
                echo "Could Not upload";
            }
        } else {
            $folder = $blog['blog_image'];
        }


        $update_blog = "UPDATE blog SET blog_image = ?, blog_title = ?, blog_content = ? WHERE id = ?";
        $query = $conn->prepare($update_blog);
        $query->bind_param("sssi", $folder, $blog_title, $blogContent, $blogid);

        if($query->execute()){
            echo "
                <script>
                    window.location.href = 'dashboard.php';
                </script>
            ";
        }else{
            echo "<div class='alert alert-danger'>Could Not Update $conn->error</div>";
        }

        
    }
    

    // -------------------------------------------------------------------------------------
    // update press post 
    if(isset($_POST['updatepress'])){
        $presstitle = htmlspecialchars($_POST['presstitle']);
        $pressid = htmlspecialchars($_POST['pressid']); 
        $pressContent = $_POST['pressContent'];
        
        $select_blog = "SELECT * FROM press WHERE id = ?";
        $query = $conn->prepare($select_blog);
        $query->bind_param('i', $pressid);
        $query->execute();
        $result = $query->get_result();
        $press = $result->fetch_assoc();

        $old_image = $press['press_image'];

        if (isset($_FILES['press_image']) && $_FILES['press_image']['error'] === UPLOAD_ERR_OK && !empty($_FILES['press_image']['name'])) {
            $originalName = $_FILES['press_image']['name'];
            $tmp_name = $_FILES['press_image']['tmp_name'];

            $ext = pathinfo($originalName, PATHINFO_EXTENSION);

            $newFileName = time() . '_' . uniqid() . '.' . $ext;

            $folder = "../assets/pressimages/" . $newFileName;

            if ($old_image && file_exists($old_image)) {
                unlink($old_image);
            }

            if (move_uploaded_file($tmp_name, $folder)) {
                // bla bla bla sheep have u any wool ......  yes sir yes sir three bags full ....sing or life 
            } else {
                echo "Could Not upload";
            }
        } else {
            $folder = $press['press_image'];
        }


        $update_blog = "UPDATE press SET press_image = ?, press_title = ?, press_content = ? WHERE id = ?";
        $query = $conn->prepare($update_blog);
        $query->bind_param("sssi", $folder, $presstitle, $pressContent, $pressid);

        if($query->execute()){
            echo "
                <script>
                    window.location.href = 'dashboard.php';
                </script>
            ";
        }else{
            echo "<div class='alert alert-danger'>Could Not Update $conn->error</div>";
        }

        
    }


    // ---------------------------------------------------------------------------------------
    // delete post 
    if(isset($_POST['delete_post'])){
        $post_id = htmlspecialchars($_POST['postid']);

        $query = "DELETE FROM blog WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('i', $post_id);
        
        if($stmt->execute()){
            echo "
                <script>
                    window.location.href = 'dashboard.php';
                </script>
            ";
        }else{
            echo "<div class='alert alert-danger'>Could Not Update $conn->error</div>";
        }
    }


    // ---------------------------------------------------------------------------------------
    // delete press 
    if(isset($_POST['delete_press'])){
        $post_id = htmlspecialchars($_POST['postid']);

        $query = "DELETE FROM press WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('i', $post_id);
        
        if($stmt->execute()){
            echo "
                <script>
                    window.location.href = 'dashboard.php';
                </script>
            ";
        }else{
            echo "<div class='alert alert-danger'>Could Not Update $conn->error</div>"; 
        }
    }