<?php 
    require_once "connect.php";

    $blog_per_pages = 5; 
    if (isset($_GET['page']) && is_numeric($_GET['page'])) {
        $current_page = (int) $_GET['page'];
    } else {
        $current_page = 1;
    }

    if ($current_page < 1) {
        $current_page = 1;
    }

    // --- Calculate Total Records and Pages ---
    $total_blogs = "SELECT COUNT(*) AS total FROM blog";
    $results = $conn->query($total_blogs);
    $blogs = $results->fetch_assoc();
    $total = $blogs['total'];

    $total_pages = ceil($total / $blog_per_pages);

    if ($current_page > $total_pages && $total_pages > 0) {
        $current_page = $total_pages;
    }

    if ($total_pages == 0 && $current_page > 1) {
        $current_page = 1;
    }

    // --- Fetch Records for Current Page ---
    $offset = ($current_page - 1) * $blog_per_pages;
    $items_query = "SELECT * FROM blog ORDER BY id DESC LIMIT ?, ?";
    $stmt = $conn->prepare($items_query);
    $stmt->bind_param( "ii", $offset, $blog_per_pages);
    $stmt->execute();
    $blogs_result = $stmt->get_result();




    // show 50 words 
    function show50words($texts, $number){
        $sentence = explode(' ', $texts);

        if(count($sentence) > $number){
            $breakword = implode(' ', array_slice($sentence, 0, $number))."...";

            return $breakword;
        }else{
            return $texts;
        }
    }