<?php 
    session_start();
    if(!isset($_SESSION['username'])){
        header("location: index.php");
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title> Oguninvest Admin  </title>
    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="../assets/images/ogunlogopreloader.png" />
    <link rel="icon" type="image/png" sizes="32x32" href="../assets/images/ogunlogopreloader.png" />
    <link rel="icon" type="image/png" sizes="16x16" href="../assets/images/ogunlogopreloader.png" />
    <link rel="manifest" href="../assets/images/favicons/site.webmanifest" />

    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">

    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <link href="https://fonts.googleapis.com/css2?family=Kumbh+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">


    <link rel="stylesheet" href="../assets/vendors/bootstrap/css/bootstrap.min.css" />
    <link rel="stylesheet" href="../assets/vendors/fontawesome/css/all.min.css" />
   <style>
        :root {
            --primary: #00a550;
            --secondary: #1b1525;
            --light: #ffffff;
        }
        
        body {
            background-color: #f8f9fa;
            color: var(--secondary);
        }
        
        .sidebar {
            background-color: var(--secondary);
            color: var(--light);
            min-height: 100vh;
            position: fixed;
            width: 250px;
        }
        
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            margin-bottom: 5px;
        }
        
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            color: var(--light);
            background-color: rgba(0, 165, 80, 0.2);
        }
        
        .sidebar .nav-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .main-content {
            margin-left: 250px;
            padding: 20px;
        }
        
        .navbar {
            background-color: var(--light);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .btn-primary {
            background-color: var(--primary);
            border-color: var(--primary);
        }
        
        .card {
            border: none;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 20px;
            border-radius: 10px;
        }
        
        .stat-card {
            border-left: 4px solid var(--primary);
            transition: transform 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-card .card-title {
            color: #6c757d;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .stat-card .card-value {
            font-size: 28px;
            font-weight: 700;
            color: var(--secondary);
        }
        
        .stat-card .card-icon {
            font-size: 40px;
            color: var(--primary);
            opacity: 0.2;
            position: absolute;
            right: 20px;
            top: 20px;
        }
        
        .recent-posts .badge {
            font-weight: 500;
            padding: 5px 10px;
        }
        
        .chart-container {
            position: relative;
            height: 300px;
        }
        
        .logo {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .logo h3 {
            color: var(--light);
            font-weight: 700;
        }
        
        .logo span {
            color: var(--primary);
        }
        .pagination .page-item.active .page-link {
            background-color: #00a550;
            border-color: #00a550;
        }
        
        .pagination .page-link {
            color: #1b1525;
        }
    </style>


</head>
<body>
    <!-- /.preloader -->
    <div class="page-wrapper"></div>

    <?php 
        include "AdminController.php"; 
        require_once "GetBlogs.php";
        require_once "GetPress.php";
    ?>
    

    <div class="sidebar">
        <div class="logo">
            <img src="../assets/images/logoinvesoguntani.gif" alt="" class="img-fluid">
            <!-- <h3>Admin<span>Panel</span></h3> -->
        </div>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home-tab-pane" type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
            </li>


            <li class="nav-item">
                <a class="nav-link" href="#"  id="blog-tab" data-bs-toggle="tab" data-bs-target="#blog-tab-pane" type="button" role="tab" aria-controls="blog-tab-pane" aria-selected="false">
                    <i class="fas fa-blog"></i> Blog Management
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"  id="press-tab" data-bs-toggle="tab" data-bs-target="#press-tab-pane" type="button" role="tab" aria-controls="press-tab-pane" aria-selected="false">
                    <i class="fas fa-newspaper"></i> Press Management
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="logout.php">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </li>
        </ul>
    </div>

    <div class="main-content">
        <nav class="navbar navbar-expand-lg">
            <div class="container-fluid">
                <h4 class="mb-0">Admin Management</h4>
                <div class="d-flex align-items-center">
                    <div class="dropdown me-3">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle me-1"></i> <?=$_SESSION['username']?>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#">Profile</a></li>
                            <li><a class="dropdown-item" href="#">Settings</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>


        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab" tabindex="0">   
                
            <!-- Stats Cards Row -->
            <div class="row my-5">
                <div class="col-md-6">
                    <div class="card stat-card">
                        <div class="card-body">
                            <i class="fas fa-file-alt card-icon"></i>
                            <h6 class="card-title">Total Blog Posts</h6>
                            <?php 
                                $total_blogs = "SELECT COUNT(*) AS total FROM blog";
                                $results = $conn->query($total_blogs);
                                $blogs = $results->fetch_assoc();
                                $total = $blogs['total'];
                            ?>
                            <h2 class="card-value"><?=$blogs['total']?></h2>
                            <span class="text-success"><i class="fas fa-arrow-up"></i> <?=$blogs['total']?> Blogs posted this month</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card stat-card">
                        <div class="card-body">
                            <i class="fas fa-comments card-icon"></i>
                            <h6 class="card-title">Total Press Releases</h6>
                            <?php 
                                $total_press = "SELECT COUNT(*) AS total FROM press";
                                $results = $conn->query($total_press);
                                $press = $results->fetch_assoc();
                                $total = $press['total'];
                            ?>
                            <h2 class="card-value"><?=$press['total']?></h2>
                            <span class="text-success"><i class="fas fa-arrow-up"></i> <?=$press['total']?> Press Released this month</span>
                        </div>
                    </div>
                </div>
            
            </div>

             <!-- Recent Posts & Activity Row -->
            <div class="row mt-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Recent Blog Posts</h5>
                        </div>
                        <div class="card-body">
                            <div class="list-group list-group-flush recent-posts">

                                <?php 
                                        $query = "SELECT * FROM blog ORDER BY id DESC LIMIT 10";
                                        $stmt = $conn->prepare($query);
                                        $stmt->execute();
                                        $results = $stmt->get_result();
                                        if($results->num_rows > 0):
                                            while($result = $results->fetch_assoc()):
                                            $date = new DateTime($result['posted_at']);
                                            $dateposted = $date->format('F j, Y');
                                ?>
                                <a href="#" class="list-group-item list-group-item-action">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-1"><?=$result['blog_title']?></h6>
                                        <span class="text-success">Published</span>
                                    </div>
                                    <small class="text-muted">Posted <?=$dateposted?></small>
                                </a>


                                <?php 
                                            endwhile;
                                    else:
                                        echo "<div class='text-center'>No Blogs Available</div>";
                                    endif;
                                ?>

                            </div>
                        </div>
                    </div>
                </div>


                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Recent Press Releases</h5>
                        </div>
                        <div class="card-body">
                            <div class="list-group list-group-flush recent-posts">

                                <?php 
                                        $query = "SELECT * FROM press ORDER BY id DESC LIMIT 10";
                                        $stmt = $conn->prepare($query);
                                        $stmt->execute();
                                        $results = $stmt->get_result();
                                        if($results->num_rows > 0):
                                            while($result = $results->fetch_assoc()):
                                            $date = new DateTime($result['posted_at']);
                                            $dateposted = $date->format('F j, Y');
                                ?>
                                <a href="#" class="list-group-item list-group-item-action">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-1"><?=$result['press_title']?></h6>
                                        <span class="text-success">Published</span>
                                    </div>
                                    <small class="text-muted">Posted <?=$dateposted?></small>
                                </a>


                                <?php 
                                            endwhile;
                                    else:
                                        echo "<div class='text-center'>No Blogs Available</div>";
                                    endif;
                                ?>

                            </div>
                        </div>
                    </div>
                </div>


            </div>

            </div>


            <div class="tab-pane fade" id="blog-tab-pane" role="tabpanel" aria-labelledby="blog-tab" tabindex="0">

                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">All Blog Posts</h5>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addBlogModal">
                                    <i class="fas fa-plus me-1"></i> Add New Blog
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th width="5%">#</th>
                                                <th width="25%">Title</th>
                                                <th width="15%">Author</th>
                                                <th width="15%">Date</th>
                                                <th width="10%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            <?php 
                                                if($blogs_result->num_rows > 0):
                                                    $number = 1;
                                                    while($blog = $blogs_result->fetch_assoc()):
                                                            $date = new DateTime($blog['posted_at']);
                                                            $format = $date->format('F j, Y');
                                            ?>

                                                        <tr>
                                                            <td><?=$number++?></td>
                                                            <td><?=$blog['blog_title']?></td>
                                                            <td><?=$blog['posted_by']?></td>
                                                            <td><?=$format?></td>
                                                            <td>
                                                                <button class="btn btn-sm btn-outline-primary me-1" data-bs-toggle="modal" data-bs-target="#editBlogModal<?=$blog['id']?>">
                                                                    <i class="fas fa-edit"></i>
                                                                </button>
                                                                <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?=$blog['id']?>">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                        
                                                        <!-- Edit Blog Modal -->
                                                        <div class="modal fade" id="editBlogModal<?=$blog['id']?>" tabindex="-1" aria-labelledby="editBlogModalLabel" aria-hidden="true">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="editBlogModalLabel">Edit Blog Post</h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <form id="editBlogForm<?=$blog['id']?>" enctype="multipart/form-data" method="post">
                                                                            <input type="hidden" name="blogid" value="<?=$blog['id']?>">
                                                                            <div class="mb-3">
                                                                                <label for="editBlogTitle" class="form-label">Blog Title</label>
                                                                                <input type="text" name="blogtitle" class="form-control" id="editBlogTitle" value="<?=$blog['blog_title']?>" required>
                                                                            </div>
                                                                            <div class="mb-3">
                                                                                <label for="editBlogImage" class="form-label">Blog Image</label>
                                                                                <input class="form-control" name="blog_image" type="file" id="editBlogImage">
                                                                                <img src="<?=$blog['blog_image']?>" alt="Blog Image" width="200" class=mt-3>
                                                                            </div>
                                                                            <div class="mb-3">
                                                                                <label for="editBlogContent" class="form-label">Content</label>
                                                                                <textarea class="form-control" name="blogContent" id="editBlogContent" rows="10" required><?=html_entity_decode($blog['blog_content'])?></textarea>
                                                                            </div>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                                                <button type="submit" name="updateBlog" id="editBlogForm" class="btn btn-primary">Update Blog</button>
                                                                            </div>
                                                                        </form>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Delete Confirmation Modal -->
                                                        <div class="modal fade" id="deleteModal<?=$blog['id']?>" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header bg-danger text-white">
                                                                        <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                                                                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <p>Are you sure you want to delete this blog post? This action cannot be undone.</p>
                                                                        <p class="fw-bold"><?=$blog['blog_title']?></p>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                        <form method="post" id="deletePost<?=$blog['id']?>">
                                                                            <input type="hidden" name="postid" value="<?=$blog['id']?>">
                                                                            <button type="submit" name="delete_post" class="btn btn-danger">Delete Permanently</button>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endwhile; ?>
                                            <?php else: ?>
                                                <tr class="text-center">
                                                    <td colspan="5">NO BLOG AVAILABLE YET</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>

                                    <?php if($total_pages > 0): ?>
                                    <nav aria-label="Page navigation">
                                        <ul class="pagination justify-content-center">
                                            <li class="page-item <?php if ($current_page <= 1) { echo 'disabled'; } ?>">
                                                <a class="page-link" href="<?php if ($current_page > 1) { echo '?page=' . ($current_page - 1); } else { echo '#'; } ?>">Previous</a>
                                            </li>

                                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                                <li class="page-item <?php if ($i == $current_page) { echo 'active'; } ?>">
                                                    <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                                </li>
                                            <?php endfor; ?>

                                            <li class="page-item <?php if ($current_page >= $total_pages) { echo 'disabled'; } ?>">
                                                <a class="page-link" href="<?php if ($current_page < $total_pages) { echo '?page=' . ($current_page + 1); } else { echo '#'; } ?>">Next</a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                    <!-- Add Blog Modal -->
                    <div class="modal fade" id="addBlogModal" tabindex="-1" aria-labelledby="addBlogModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="addBlogModalLabel">Add New Blog Post</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="addBlogForm" enctype="multipart/form-data" method="post">
                                        <div class="mb-3">
                                            <label for="blogTitle" class="form-label">Blog Title</label>
                                            <input type="text" name="title" class="form-control" id="blogTitle" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="blogImage" class="form-label">Blog Image</label>
                                            <input class="form-control" name="blogimage" type="file" id="blogImage" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="blogContent" class="form-label">Content</label>
                                            <textarea class="form-control" name="blogcontent" id="blogContent" rows="10" required></textarea>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="submit" name="publish" form="addBlogForm" class="btn btn-primary">Publish Blog</button>
                                </div>
                            </div>
                        </div>
                    </div>

            </div>



            <!-- Press Releases  -->
            <div class="tab-pane fade" id="press-tab-pane" role="tabpanel" aria-labelledby="press-tab" tabindex="0">

                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">All Press Posts</h5>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPress">
                                    <i class="fas fa-plus me-1"></i> Add New Release
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th width="5%">#</th>
                                                <th width="25%">Title</th>
                                                <th width="15%">Author</th>
                                                <th width="15%">Date</th>
                                                <th width="10%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            <?php 
                                                if($presss_result->num_rows > 0):
                                                    $number = 1;
                                                    while($press = $presss_result->fetch_assoc()):
                                                            $date = new DateTime($press['posted_at']);
                                                            $format = $date->format('F j, Y');
                                            ?>

                                                <tr>
                                                    <td><?=$number++?></td>
                                                    <td><?=$press['press_title']?></td>
                                                    <td><?=$press['posted_by']?></td>
                                                    <td><?=$format?></td>
                                                    <td>
                                                        <button class="btn btn-sm btn-outline-primary me-1" data-bs-toggle="modal" data-bs-target="#editpressModal<?=$press['id']?>">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                        <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?=$press['id']?>">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                                
                                                <!-- Edit press Modal -->
                                                <div class="modal fade" id="editpressModal<?=$press['id']?>" tabindex="-1" aria-labelledby="editBlogModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="editpressModalLabel">Edit press Post</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <form id="editpressForm<?=$press['id']?>" enctype="multipart/form-data" method="post">
                                                                    <input type="hidden" name="pressid" value="<?=$press['id']?>">
                                                                    <div class="mb-3">
                                                                        <label for="editpressTitle" class="form-label">press Title</label>
                                                                        <input type="text" name="presstitle" class="form-control" id="editpressTitle" value="<?=$press['press_title']?>" required>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="editpressImage" class="form-label">press Image</label>
                                                                        <input class="form-control" name="press_image" type="file" id="editpressImage">
                                                                        <img src="<?=$press['press_image']?>" alt="press Image" width="200" class=mt-3>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="editpressContent" class="form-label">Content</label>
                                                                        <textarea class="form-control" name="pressContent" id="editpressContent" rows="10" required><?=html_entity_decode($press['press_content'])?></textarea>
                                                                    </div>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                                        <button type="submit" name="updatepress" id="editpressForm" class="btn btn-primary">Update press</button>
                                                                    </div>
                                                                </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Delete Confirmation Modal -->
                                                <div class="modal fade" id="deleteModal<?=$press['id']?>" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header bg-danger text-white">
                                                                <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                                                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <p>Are you sure you want to delete this press post? This action cannot be undone.</p>
                                                                <p class="fw-bold"><?=$press['press_title']?></p>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                <form method="post" id="deletePost<?=$press['id']?>">
                                                                    <input type="hidden" name="postid" value="<?=$press['id']?>">
                                                                    <button type="submit" name="delete_press" class="btn btn-danger">Delete Permanently</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                    <?php endwhile; ?>
                                            <?php else: ?>
                                                <tr class="text-center">
                                                    <td colspan="5">NO BLOG AVAILABLE YET</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>

                                    <?php if($total_pages > 0): ?>
                                    <nav aria-label="Page navigation">
                                        <ul class="pagination justify-content-center">
                                            <li class="page-item <?php if ($current_page <= 1) { echo 'disabled'; } ?>">
                                                <a class="page-link" href="<?php if ($current_page > 1) { echo '?page=' . ($current_page - 1); } else { echo '#'; } ?>">Previous</a>
                                            </li>

                                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                                <li class="page-item <?php if ($i == $current_page) { echo 'active'; } ?>">
                                                    <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                                </li>
                                            <?php endfor; ?>

                                            <li class="page-item <?php if ($current_page >= $total_pages) { echo 'disabled'; } ?>">
                                                <a class="page-link" href="<?php if ($current_page < $total_pages) { echo '?page=' . ($current_page + 1); } else { echo '#'; } ?>">Next</a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Add Blog Modal -->
                <div class="modal fade" id="addPress" tabindex="-1" aria-labelledby="addPressLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addBlogModalLabel">Add New Press Release</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form id="addBlogForm" enctype="multipart/form-data" method="post">
                                    <div class="mb-3">
                                        <label for="presstitle" class="form-label">Title</label>
                                        <input type="text" name="title" class="form-control" id="presstitle" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="pressimage" class="form-label">Image</label>
                                        <input class="form-control" name="pressimage" type="file" id="pressimage" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="pressContent" class="form-label">Content</label>
                                        <textarea class="form-control" name="pressContent" id="pressContent" rows="10" required></textarea>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="submit" name="publishpress" id="addpress" class="btn btn-primary">Publish</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div> 

            </div>


        </div>

    </div>







    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Sample JavaScript for blog management
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
            
            // Delete button functionality
            document.querySelectorAll('.btn-outline-danger').forEach(button => {
                button.addEventListener('click', function() {
                    var blogTitle = this.closest('tr').querySelector('td:nth-child(2)').textContent;
                    document.querySelector('#deleteModal .fw-bold').textContent = '"' + blogTitle + '"';
                    var deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                    deleteModal.show();
                });
            });
        });
        </script>


</body>

</html>