document.addEventListener('DOMContentLoaded', function() {
    // Responsive Navbar
    const menuButton = document.querySelector('.mobile-menu-button');
    const mobileMenu = document.getElementById('mobile-menu-content');

    menuButton.addEventListener('click', () => {
        const isMenuVisible = mobileMenu.style.display === 'block';
        mobileMenu.style.display = isMenuVisible ? 'none' : 'block';
    });

    // carousel functionality
    const slides = document.querySelectorAll('.carousel-slide');
    const prevBtn = document.getElementById('prev-btn');
    const nextBtn = document.getElementById('next-btn');
    
    let currentSlide = 0;
    const totalSlides = slides.length;

    function goToSlide(slideIndex) {
        currentSlide = (slideIndex + totalSlides) % totalSlides;
        
        slides.forEach((slide, index) => {
            slide.style.opacity = (index === currentSlide) ? '1' : '0';
            slide.style.zIndex = (index === currentSlide) ? '10' : '0';
        });
    }

    nextBtn.addEventListener('click', () => {
        goToSlide(currentSlide + 1);
    });

    prevBtn.addEventListener('click', () => {
        goToSlide(currentSlide - 1);
    });
    
    let slideInterval = setInterval(() => {
        goToSlide(currentSlide + 1);
    }, 5000);


    // Pause auto-play on hover (optional but good UX)
    const carousel = document.getElementById('hero-carousel');
    carousel.addEventListener('mouseenter', () => {
        clearInterval(slideInterval);
    });
    carousel.addEventListener('mouseleave', () => {
        slideInterval = setInterval(() => {
            goToSlide(currentSlide + 1);
        }, 5000);
    });

    goToSlide(0);

    // --- DROPDOWN FUNCTIONALITY FOR DESKTOP REMOVED ---
    // document.querySelectorAll('.main-nav .dropdown-toggle').forEach(function(toggle) {
    //     toggle.addEventListener('click', function(e) {
    //         e.preventDefault();
    //         // Close other open dropdowns
    //         document.querySelectorAll('.main-nav .dropdown').forEach(function(drop) {
    //             if (drop !== toggle.parentElement) {
    //                 drop.classList.remove('open');
    //             }
    //         });
    //         // Toggle current dropdown
    //         toggle.parentElement.classList.toggle('open');
    //     });
    // });

    // Optional: Close dropdowns when clicking outside (desktop)
    // window.addEventListener('click', function(e) {
    //     document.querySelectorAll('.main-nav .dropdown').forEach(function(drop) {
    //         if (!drop.contains(e.target)) {
    //             drop.classList.remove('open');
    //         }
    //     });
    // });

    // Mobile menu toggle (fix selector typo and logic)
    const mobileMenuBtn = document.querySelector('.mobile-menu-button');
    const mobileNav = document.querySelector('.mobile-nav');

    if (mobileMenuBtn && mobileNav) {
        mobileMenuBtn.addEventListener('click', function(e) {
            e.stopPropagation();
            mobileNav.classList.toggle('open');
        });
        // Close mobile nav when clicking outside
        window.addEventListener('click', function(e) {
            if (!mobileNav.contains(e.target) && !mobileMenuBtn.contains(e.target)) {
                mobileNav.classList.remove('open');
            }
        });
    }

    // Mobile dropdowns
    if (mobileNav) {
        mobileNav.querySelectorAll('.dropdown-toggle').forEach(function(toggle) {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                // Close other open dropdowns in mobile nav
                mobileNav.querySelectorAll('.dropdown').forEach(function(drop) {
                    if (drop !== toggle.parentElement) {
                        drop.classList.remove('open');
                    }
                });
                // Toggle current dropdown
                toggle.parentElement.classList.toggle('open');
            });
        });
    }

    // Hero contents card fade carousel
    function heroContentsCardCarousel() {
      const cards = document.querySelectorAll('.hero-contents-card .conts');
      if (!cards.length) return;
      let idx = 0;
      function showCard(i) {
        cards.forEach((c, j) => c.classList.toggle('active', i === j));
      }
      showCard(idx);
      setInterval(() => {
        idx = (idx + 1) % cards.length;
        showCard(idx);
      }, 7000);
    }
    heroContentsCardCarousel();
});



// Video Playing Functionality

const playButton = document.querySelector('.play-button');
const overlay = document.querySelector('.overlay');
const videoPlayerPopup = document.querySelector('.video-player-popup');
const body = document.querySelector('body');
const closeBtn = document.getElementById('closeVideoPopup');
const vimeoIframe = document.getElementById('ogunVimeo');
const vimeoSrc = vimeoIframe ? vimeoIframe.getAttribute('src') : null;

function closeVideoPopupFn() {
    overlay.classList.remove('active');
    videoPlayerPopup.classList.remove('active');
    body.style.overflow = "auto";
    if (vimeoIframe) {
        vimeoIframe.setAttribute('src', ''); // Unload video
        setTimeout(() => {
            vimeoIframe.setAttribute('src', vimeoSrc); // Reset for next open
        }, 200);
    }
}

playButton.addEventListener('click', () => {
    overlay.classList.add('active');
    videoPlayerPopup.classList.add('active');
    body.style.overflow = "hidden";
});

overlay.addEventListener('click', closeVideoPopupFn);
if (closeBtn) {
    closeBtn.addEventListener('click', closeVideoPopupFn);
}