<?php
$tagline="Discover Investment Opportunities in Ogun State";
$bannerimage="assets/images/searchbanner.jpg";
$pagetitle ="OgunInvest";
$page = "Search Result on OgunInvest Website";
$pagecaption = "Nigeria's Current Industrial Hub";
$pagedescription = "Discover investment opportunities in Ogun State, Nigeria. Foster partnerships, facilitate investments, and explore economic growth in West Africa's business hub.";
$pagekeywords ="Ogun State investment opportunities, Invest in Ogun State, Business opportunities in Ogun State, Economic development in Nigeria, Ogun State business hub, Investment agency Nigeria, Ogun investment agency, Investment promotion Nigeria";
?>
<!DOCTYPE html>
<html lang="en">

<?php 
include("includes/headers.php");
?>


<?php
  // Add more pages if needed
$query = strtolower($_GET['query']);
$base_url = "http://localhost/oguninvest/"; // Replace with your actual website URL

$pagenew_list = [
    "home.php",
    "aboutogunstate.php",
    "services.php",
    "contactus.php",
    "agriculture.php",
    "culture.php",
    "economic-cluster.php",
    "energy.php",
    "feeslevy.php",
    "functiongoalamb.php",
    "goals.php",
    "ict.php",
    "infographics.php",
    "investmennt-compedium.php",
    "investmentjourney.php",
    "investmentopportunities.php",
    "landprocessing.php",
    "latest-news.php",
    "management.php",
    "manufacturing.php",
    "mission.php",
    "news-details.php",
    "press-details.php",
    "press-release.php",
    "solidminerals.php",
    "successstories.php",
    "the-network.php",
    "transportation.php",
    "whyinvest.php",
    "whoweare.php"
]; // Add more pages if needed

$results = [];

foreach ($pagenew_list as $pagenew) {
    $url = $base_url . $pagenew;
    $html = @file_get_contents($url);

    if ($html === false) {
        continue; // Skip if the page is inaccessible
    }

    $clean_text = extract_clean_text($html); // Extract only visible content

    if (stripos($clean_text, $query) !== false) {
        $title = get_page_title($html);
        $excerpt = get_excerpt($clean_text, $query);

        $results[] = [
            'url' => $url,
            'title' => $title ?: "Untitled Page",
            'excerpt' => $excerpt
        ];
    }
}

// Function to extract the <title> tag from the live HTML
function get_page_title($html) {
    preg_match("/<title>(.*?)<\/title>/is", $html, $matches);
    return $matches[1] ?? null;
}

// Function to extract only visible text from the <body> tag
function extract_clean_text($html) {
    // Extract content inside <body> only
    preg_match("/<body[^>]*>(.*?)<\/body>/is", $html, $matches);
    $body_content = $matches[1] ?? $html;

    // Remove all script, style, and other non-text elements
    $body_content = preg_replace('/<script.*?<\/script>/is', '', $body_content);
    $body_content = preg_replace('/<style.*?<\/style>/is', '', $body_content);
    $body_content = preg_replace('/<[^>]+>/', ' ', $body_content); // Remove all HTML tags
    $body_content = preg_replace('/\s+/', ' ', $body_content); // Remove extra spaces

    return trim($body_content);
}

// Function to extract an excerpt from actual page text with keyword highlighting
function get_excerpt($text, $query, $length = 150) {
    $pos = stripos($text, $query);
    if ($pos === false) return "";

    // Extract a portion of text around the keyword
    $start = max(0, $pos - $length / 2);
    $excerpt = substr($text, $start, $length);

    // Highlight the found keyword
    return preg_replace("/(" . preg_quote($query, '/') . ")/i", "<strong style='background-color: yellow;'>$1</strong>", htmlspecialchars($excerpt));
}
?>

<body>

<?php 
//include("includes/preloader.php");
?>


    
    <!-- /.preloader -->
    <div class="page-wrapper">
    <?php 
include("includes/navigation.php");
?>

        <div class="stricky-header stricked-menu main-menu">
            <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
        </div><!-- /.stricky-header -->

    <?php include("includes/breadcrumb.php"); ?>

  
        <!--Service Details Start-->
        <section class="service-details">
            <div class="container">
            <div class="section-title text-center">
                    <div class="section-title__tagline-box">
                        <span class="section-title__tagline"><?php echo $tagline; ?></span>
                        <div class="section-title-shape">
                            <img src="assets/images/shapes/section-title-shape.png" alt="">
                        </div>
                    </div>
                    <h2 class="section-title__title">Search Results for "<?php echo htmlspecialchars($query); ?>"</h2><?php echo count($results); ?> results found for "<?php echo htmlspecialchars($query); ?>
              
                </div>
                <div class="row">
                    
                    <div class="col-xl-8 col-lg-7">
                        <div class="service-details__right">
                            
                            
                            
                           
                            <div class="service-details__points-two">
                                <div class="row">


                                    <?php if (empty($results)) : ?>
        <p><center><strong>No results found.</strong></center></p>
    <?php else : ?>
        <ol>
            <?php foreach ($results as $result) : ?>
                <li>
                    <a style ="background-color:aquamarine; padding:20px; width=100%" href="<?php echo htmlspecialchars($result['url']); ?>">
                        <?php echo htmlspecialchars($result['title']); ?>
                    </a>
                    <p style="margin-bottom: 30px; margin-top: 30px;"><?php echo $result['excerpt']; ?>...</p>
                </li>
            <?php endforeach; ?>
        </ol>
    <?php endif; ?>  


                                </div>
                            </div>
                           
                           
                        </div>
                    </div>

                   
                            <?php include("includes/sectorsleft.php"); ?>
                          
                </div>
            </div>
        </section>
        <!--Service Details End-->


    

        <?php include("includes/footer.php") ?>

    </div><!-- /.page-wrapper -->
    
    <?php include("includes/footerscript.php") ?>
</body>

</html>