<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invest in Ogun State</title>
    <link rel="shortcut icon" href="images/ologo.png" type="image/x-icon">
    <meta name="description" content="Invest in Ogun State, Nigeria - Explore diverse investment opportunities in agriculture, manufacturing, logistics, and more.">
    <meta name="keywords" content="Ogun State, investment, agriculture, manufacturing, logistics, tourism, technology, real estate, government support">
    <meta name="author" content="Ogun State Government">
    <meta property="og:title" content="Invest in Ogun State">
    <meta property="og:description" content="Discover the investment potential of Ogun State,">
    <meta property="og:image" content="images/ologo.png">
    <meta property="og:url" content="https://invest.ogunstate.gov.ng">
    <meta property="og:type" content="website">
    <link rel="stylesheet" href="./fontawesome-free-6.4.2-web/css/all.css">
    <link rel="stylesheet" href="styles/style.css">
</head>
<body>


   <?php include("includes/header.php") ;?>


    <?php include("includes/mobileheader.php") ;?>


    <main>
        <!-- Hero Section Carousel -->
      

        <!-- Vision Section -->
        <section class="vision-section">
            <div class="container">
                <div class="vision-grid">
                    <div class="overlay"></div>
                    <div class="video-player-popup" id="videoPopup">
                        <button class="close-video-popup" id="closeVideoPopup" style="position:absolute;top:10px;right:10px;z-index:2;font-size:2rem;background:none;border:none;color:white;cursor:pointer;">&times;</button>
                        <div style="padding:56.25% 0 0 0;position:relative;">
                            <iframe id="ogunVimeo" src="https://player.vimeo.com/video/1090024069?h=99dca8db7b&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479&amp;dnt=1" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Invest In Ogun State"></iframe>
                        </div>
                        <script src="https://player.vimeo.com/api/player.js"></script>
                        <div class="video-caption">
                            <p>HIS EXCELLENCY</p>
                            <h3>PRINCE DAPO ABIODUN, <span>CON</span></h3>
                        </div>
                    </div>

                    <div class="video-player-mockup">
                        <img src="./images/govogun3.jpg" alt="Image of the Governor">
                        <span class="fa fa-play play-button"></span>
                    </div>
                    <div  class="vision-text">
                        <h2 style="text-transform:uppercase; font-size: 25px;">Ogun State is Nigeria’s <br>premier investment frontier</h2>
                        <p>
                         Ogun State is strategically positioned, richly endowed, and boldly future-focused. Located next to Lagos, Africa’s fifth-largest economy, the Gateway state offers unrivaled access to domestic and international markets, powered by cutting-edge infrastructure such as the Gateway Agro-Cargo Airport, Kajola Dry Port City, and the proposed Olokola Deep Sea Port
                            <br><br>
                            OgunInvest is the engine behind Ogun State’s dynamic investment climate - 
                            bridging opportunity with execution for both local and global investors. 
                            The agency is strategically positioned to actualize the state’s ambition 
                            of becoming Nigeria’s industrial capital and a top investment destination 
                            in West Africa. </p>
                        
                        <div class="govcontainer">
                        <div class="column">
                                <p class="governor-name">HIS EXCELLENCY, <BR>PRINCE DAPO ABIODUN, <span><em>CON</em></span>
                                <br><span class="governor-title">CHAIRMAN, OGUNNINVEST.</span></p>
                               
                                <a href="#" class="learn-more-link">
                                    <span>Learn more</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" style="height: 1.5rem; width: 1.5rem;" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd" />
                                    </svg>
                                </a>
                       </div>
                        <div class="column"> <img src="./images/qrcomp.png" width="50%" alt="Image of the Governor"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Investment Opportunities Section -->
        <section class="investment">
            <div class="container">
                <h1 style="color: #00a54f;" class="invest">Investible Sectors</h1>
                 <div class="carousel-container">
                    <div class="carousel-window">
                        <div class="carousel-track">

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/agricogun.jpg" alt="Mountain">
                                        <h3>Agriculture</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Agriculture</h4>
                                        <p>Ogun State offers exciting investment opportunities in agriculture, driven by vast expanse of arable land, strategic access to market, and strong government-backed initiatives. </p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/manufogun.jpg" alt="Mountain">
                                        <h3>Manufacturing</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Manufacturing</h4>
                                        <p>Ogun State is Nigeria’s industrial engine room—home to over 5,000 manufacturing firms and the largest concentration of industrial estates in the country.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/solidminogun.jpg" alt="Mountain">
                                        <h3>Solid Minerals</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Solid Minerals</h4>
                                        <p>Ogun State stands at the forefront of Nigeria’s solid mineral production, offering vast, untapped reserves of limestone, granite, laterite, and more.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/transogun.jpg" alt="Mountain">
                                        <h3>Transportation & Logistics</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Transportation & Logistics</h4>
                                        <p>Ogun State is a rising logistics hub with road, rail, air, and sea access—boosting trade, transport, and industry through key assets like the Agro-Cargo Airport and Kajola Dry Port.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/energyogun.jpg" alt="Mountain">
                                        <h3>Energy Sector</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Energy Sector</h4>
                                        <p>Ogun State leads in energy innovation with opportunities in IPPs, renewables, and industrial power—offering solar-ready land and a stable environment for reliable energy investment.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-front">
                                        <img src="images/cultureogun.jpg" alt="Mountain">
                                        <h3>Culture & Tourism</h3>
                                    </div>
                                    <div class="card-back">
                                        <h4>Culture & Tourism</h4>
                                        <p style="padding-right:40px;">From Nollywood sets to vibrant crafts and festivals, Ogun State blends culture, history, and entertainment—positioning tourism as a thriving investment in storytelling and creativity.</p>
                                    </div>
                                </div>
                            </div>

                            
                        </div>
                    </div>

                    <button class="carousel-btn prev-btn" id="prevBtn">‹</button>
                    <button class="carousel-btn next-btn" id="nextBtn">›</button>

                    <div class="carousel-indicators">
                    </div>
                </div>

            </div>
        </section>


        <!-- Our Services section -->
        <section id="service">
            <div class="container">
                <h1 style="color: #00a54f;" class="serve">OUR SERVICES
                    
                </h1>
                

                <div class="services-container">

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-users"></i>
                         <h3>Investment Promotion </h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                       At OgunInvest, we offer end-to-end support - from your first inquiry to full project execution. Our One-Stop-Shop model ensures that investors receive seamless, coordinated assistance across every stage of the investment lifecycle
                       </div>
                    </div>

                   

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-newspaper"></i>
                         <h3>Investment Facilitation</h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                        At OgunInvest, we promote high-potential sectors and support investors with opportunity mapping, regulatory guidance, and strategic insights—ensuring direct access to key stakeholders for smart decisions.
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-users"></i>
                         <h3> Investor Advisory</h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                        Our commitment goes beyond project launch. OgunInvest offers ongoing support—resolving challenges, enabling expansion, and linking investors with government agencies, partners, and key resources to ensure long-term business success.
                       </div>
                    </div>

                    <div class="service-card">
                       <div class="service-card-top">
                         <i class="fa fa-money-bill-1"></i>
                         <h3>Investor Aftercare</h3>
                       </div>
                       <div style="text-align: justify;" class="service-card-bottom">
                       OgunInvest provides hands-on support across the full project lifecycle—from site selection and stakeholder coordination to milestone tracking and issue resolution—ensuring your investment stays on track, on time, and aligned with your goals.
                       </div>
                    </div>

                </div>

                <!-- Add this below the services-container -->
                <div class="service-info-mobile"></div>

            </div>
        </section>
    </main>

<?php include("includes/footer.php"); ?>
    
    <script src="./scripts/script.js"></script>
    <script src="./scripts/cards.js"></script>
</body>
</html>
